#include "humans.pov"

// Here is all stuff that is not used in main file
#ifndef (TheCity)
  //#include "TheEnvironment.pov"
  light_source { <10,15,-15> color rgb .7 shadowless}
  camera { location <-20,10.5,20>*2 look_at  <12,0,49> angle 20 }
#end

/*
- Fountains
- Statues and something on the roof
- More people
*/

// People In TheTemple (riverside)
object{ human1 translate <12,0.0,56> }
object{ human1 translate <12,0.0,54> }
object{ human1 translate <9.9,0.0,56> }

object{ human1 translate <10.95,-0.2,47.45> }

#local lossi = union {
  object{ human1 rotate y*10 translate <17,0,49> }
  object{ human4 rotate y*10 translate <17,0,51> }
  object{ human3 rotate y*90 translate <18,0,49> }
  object{ human3 rotate y*90 translate <18,0,47> }
  object{ human1 translate <18,0,52> }
  object{ human5 rotate y*40 translate <21,0,52> }
  object{ human3 translate <21,0,53> }
  object{ human1 translate <21,0,54> }
  object{ human3 rotate y*100 translate <21.4,0,52.7> }
  object{ human1 translate <22,0,52> }
  object{ human1 rotate y*45 translate <22,0,53> }
  object{ human3 rotate y*180 translate <23,0,54> }
  object{ human5 translate <23,0,52> }
  object{ human3 rotate y* 33 translate <25,0,50> }
}
object {lossi }
object {lossi translate <.5,0,.2> }
object {lossi translate <2,0,1> }
object {lossi translate <1.7,0,1.2> }
object {lossi translate <3,0,-1> }
object {lossi translate <2,0,-2> }
object {lossi translate <2,0,0> }
object {lossi translate <5,0,-5> }
object {lossi translate <5,0,-4.5> }
object {lossi translate <5,0,-2> }
object {lossi translate <6,0,-4> }
object {lossi translate <5,0,5> }
object {lossi translate <6.5,0,5.5> }
object {lossi translate <8,0,6> }
object {lossi translate <8,0,2> }

#local white_marble = texture {
  #local m =
  pigment {
    marble
    colour_map {
      [.1  color rgb 1.0]
      [.5 colour rgb 0.9]
      [.9  color rgb 1.0]
    }
    turbulence 1.2
    scale 2
  }
  pigment { checker pigment { m } pigment { m rotate (x+y)*90} scale .75}
  finish { diffuse .6 }
}

#declare gold = texture { 
  pigment { 
    rgb <1.00, 0.875, 0.575>
  }
  normal { bumps scale .05 } 
  finish {     
    brilliance 2.25
    diffuse .8
    ambient .05
    reflection <.35, 0.275, 0.34>
    metallic 1
    specular .4
    roughness 1/4
  }
}

#local pylvas = union {
  cylinder { <-.5,0,0> <-.5,2,0> .125 texture { white_marble } }
  torus { .125 .05 texture {gold } translate <-.5,0.05,0> }
  torus { .125 .05 texture {gold } translate <-.5,1.8,0> }
  torus { .1 .15 texture {gold } translate <-.5,1.95,0> }
}

#local pylvas2 = union {
  cylinder { <0,0.05,0> <0,1,0> .04 texture { white_marble } }
  torus { .04 .02 texture {gold } scale <1,2,1> translate <0,0.05,0> }
}

#local pylvas3 = union {
  cylinder { <0,0,0> <0,1.5,0> .1 texture { white_marble } }
  torus { .1 .075 texture {gold } scale <1,1,1> translate <0,.05,0> }
}

#local waterwing = union {
  box { <-4,-1,0> <1.5,.05,3> texture { white_marble } }       // Basement
  box { <-3.6,0.05,0.1> <1.5,1,2.9> texture { white_marble } } // Middle partition      

  box { <-4,1,0> <1.5,1.025,3> texture { white_marble } }                 // Ceiling
  box { <-3.975,1.025,.025> <1.475,1.125,2.975> texture { gold } }        // Ceiling
  box { <-4,1.125,0> <1.5,1.15,3> texture { white_marble } }              // Ceiling

  box { <-4,1,0.8> <-4.4,1.05,2.2> texture { white_marble } }         // Ceiling above stairs
  box { <-3.975,1.05,0.825> <-4.375,1.10,2.175> texture { gold } }    // Ceiling above stairs
  box { <-4,1.10,0.8> <-4.4,1.15,2.2> texture { white_marble } }      // Ceiling above stairs

  box { <-4.4,0,0> <1.5,.05,.76> texture { white_marble } rotate <-20,0,0> translate <0,1.1,0.8> }      // Ceiling above ceiling
  box { <-4.4,0,0> <1.5,.05,-.76> texture { white_marble } rotate <20,0,0> translate <0,1.1,2.2> }      // Ceiling above ceiling
  difference {
    union {
      box { <-4.325,0,0> <1.5,-1,.78> rotate <-20,0,0> translate <0,0,0.8>}      // Ceiling above ceiling
      box { <-4.325,0,0> <1.5,-1,-.78> rotate <20,0,0> translate <0,0,2.2>}      // Ceiling above ceiling
    }
    box { <-5,0,5> <5,-2,-5> }
    texture { gold } 
    translate <0,1.125,0>
  }

  union {
    box { <-4,-1,0.8> <-4.4,0.05,2.2> texture {white_marble} }   // porras
    box { <-4,-1,0.7> <-4.5,0,2.3> texture {white_marble} }      // porras
    box { <-4,-1,0.6> <-4.6,-.05,2.4> texture {white_marble} }   // porras
    box { <-4,-1,0.5> <-4.7,-.1,2.5> texture {white_marble} }    // porras
    box { <-4,-1,0.4> <-4.8,-.15,2.6> texture {white_marble} }   // porras
    box { <-4,-1,0.3> <-4.9,-.2,2.7> texture {white_marble} }    // porras
    box { <-4,-1,0.2> <-5.0,-.25,2.8> texture {white_marble} }   // porras
    box { <-4,-1,0.1> <-5.1,-.3,2.9> texture {white_marble} }    // porras
    box { <-4,-1,0> <-5.2,-.35,3> texture {white_marble} }       // porras
    box { <-3.9,-1,-0.1> <-5.3,-.4,3.1> texture {white_marble} } // porras
    box { <-3.8,-1,-0.2> <-5.4,-.45,3.2> texture {white_marble} }// porras
      // Lazylazylazyyyy
    translate <0,-0.05,0>
    scale <1,.4,1>
    translate <0,0.05,0>
  }

  object { pylvas2 translate <-3.8,0,0.10> }
  object { pylvas2 translate <-3.8,0,0.35> }
  object { pylvas2 translate <-3.8,0,0.65> }
  object { pylvas2 translate <-3.8,0,0.95> }
  object { pylvas2 translate <-3.8,0,1.25> }
  object { pylvas2 translate <-3.8,0,1.75> }
  object { pylvas2 translate <-3.8,0,2.05> }
  object { pylvas2 translate <-3.8,0,2.35> }
  object { pylvas2 translate <-3.8,0,2.65> }
  object { pylvas2 translate <-3.8,0,2.9> }

  object { pylvas2 translate <-4.2,0,0.9> }
  object { pylvas2 translate <-4.2,0,1.2> }
  object { pylvas2 translate <-4.2,0,1.5> }
  object { pylvas2 translate <-4.2,0,1.8> }
  object { pylvas2 translate <-4.2,0,2.1> }
}

union {

  object { waterwing translate <0,-.25,0> } // southern
  object { waterwing translate <0,-.25,12>} // northern

  // Temple

  box { <-.5,-1,2.975> <15.025,.05,12.025> texture { white_marble } }         // Floor
  box { <0,-1,5.5> <1,0.05,9.5> texture { white_marble } }

  box { <.975,2,2.975> <15.025,2.0625,12.025> texture { white_marble } }            // Ceiling above pilars
  box { <1,2.0625,3> <15,2.1875,12> texture { gold } }                              // Ceiling above pilars
  box { <.975,2.1875,2.975> <15.025,2.25,12.025> texture { white_marble } }         // Ceiling above pilars

  box { <2,0,3> <15,2,12> texture { white_marble } }             // Insidebox

  box { <0,2,5.5> <1,2.065,9.5> texture { white_marble } }            // Ceiling above pilars
  box { <0.1,2.065,5.6> <1,2.1875,9.4> texture { gold } }             // Ceiling above pilars
  box { <0,2.1875,5.5> <1,2.25,9.5> texture { white_marble } }        // Ceiling above pilars

  box { <0,0,0> <15,0.0625,2.15> texture { white_marble } rotate <-20,0,0> translate <0,2.1875,5.5> }        // Ceiling above pilars
  box { <0,0,0> <15,-0.0625,2.15> texture { white_marble } rotate <-160,0,0> translate <0,2.1875,9.5> }        // Ceiling above pilars

  difference {
    union {    
      box { <0.05,0,0> <15,-1,2.15> rotate <-20,0,0> translate <0,0,5.5> }        // Ceiling above pilars
      box { <0.05,0,0> <15,1,2.15> rotate <-160,0,0> translate <0,0,9.5> }        // Ceiling above pilars
    }
    box { <-5,-5,-15> <25,0,15> }
    texture { gold } 
    translate <0,2.1875,0>
  }

  object { pylvas translate <0.9,0,6.0> }
  object { pylvas translate <0.9,0,6.5> }
  object { pylvas translate <0.9,0,7.0> }
  object { pylvas translate <0.9,0,7.5> }
  object { pylvas translate <0.9,0,8.0> }
  object { pylvas translate <0.9,0,8.5> }
  object { pylvas translate <0.9,0,9.0> }
  
    // Riverside pilars
  object { pylvas translate <1.7,0,3.5> }
  object { pylvas translate <1.7,0,4.0> }
  object { pylvas translate <1.7,0,4.5> }
  object { pylvas translate <1.7,0,5.0> }
  object { pylvas translate <1.7,0,5.5> }
  object { pylvas translate <1.7,0,6.0> }
  object { pylvas translate <1.7,0,6.5> }
  object { pylvas translate <1.7,0,7.0> }
  object { pylvas translate <1.7,0,7.5> }
  object { pylvas translate <1.7,0,8.0> }
  object { pylvas translate <1.7,0,8.5> }
  object { pylvas translate <1.7,0,9.0> }
  object { pylvas translate <1.7,0,9.5> }
  object { pylvas translate <1.7,0,10.0> }
  object { pylvas translate <1.7,0,10.5> }
  object { pylvas translate <1.7,0,11.0> }
  object { pylvas translate <1.7,0,11.5> }

  object { pylvas translate <2.5,0,3.5> }
  // ...
  object { pylvas translate <2.5,0,11.5> }


    // Bridgeside pilars

  box { <2,-1,1.8> <15,0.05,3> texture { white_marble } }
  cylinder { <0,-1,0> <0,0.05,0> 1 scale <2.6,1,2> translate <8.5,0,2> texture { white_marble } }

  box { <2,1.5,1.8> <15,1.575,3> texture { white_marble } }
  cylinder { <0,0,0> <0,0.075,0> 1 scale <2.6,1,2> translate <8.5,1.5,2> texture { white_marble } }

  box { <2.125,1.575,1.925> <14.875,1.7,3> texture { gold } }
  cylinder { <0,0,0> <0,0.125,0> 1 scale <2.4,1,2> translate <8.5,1.575,2> texture { gold } }

  box { <2,1.7,1.8> <15,1.8,3> texture { white_marble } }
  cylinder { <0,0,0> <0,0.1,0> 1 scale <2.6,1,2> translate <8.5,1.7,2> texture { white_marble } }

  // Circular pilar formation
  #local i=0;
  #while (i<10)
    #local i=i+1;
    object { pylvas3 translate <8.5+2*cos(pi*i/10),0,2-1.5*sin(pi*i/10)> }
  #end

  // Inner circular pilar formation
  #local i=0;
  #while (i<6)
    #local i=i+1;
    object { pylvas3 translate <8.5+1.25*cos(pi*i/7),0,2.75-.9375*sin(pi*i/7)> }
  #end

  // Backrow pilars from circle to city
  #local i=0;
  #while (i<7)
    object { pylvas3 translate <15-i*.75,0,2.75> }
    #local i=i+1;
  #end

  // Backrow pilars from circle to river
  #local i=0;
  #while (i<7)
    object { pylvas3 translate <6.5-i*.75,0,2.75> }
    #local i=i+1;
  #end


  object { pylvas3 translate <14.85,0,2> }
  object { pylvas3 translate <14.25,0,2> }
  object { pylvas3 translate <13.5,0,2> }
  object { pylvas3 translate <12.75,0,2> }
  object { pylvas3 translate <12,0,2> }
  object { pylvas3 translate <11.25,0,2> }
  object { pylvas3 translate <10.5,0,2> }
  object { pylvas3 translate <5.75,0,2> }
  object { pylvas3 translate <5,0,2> }
  object { pylvas3 translate <4.25,0,2> }
  object { pylvas3 translate <3.5,0,2> }
  object { pylvas3 translate <2.75,0,2> }
  object { pylvas3 translate <2.15,0,2> }

  // Stairs
  #local i=0;
  #local p = .3; // percentages of i
  #while (i<2)
    box { <-1.0-i,0.05-p*i,5.5-i> <0.0+i,0.00-p*i,9.5+i> texture { white_marble } }
    #local i = i+.1;
  #end  

  pigment { color rgb x }
  rotate y*-35 translate <15,0,49> 
}
